//
//  Material.fsh
//  Untitled
//
//  Created by dutty on 10.10.10.
//  Copyright 2010 drahtwerk. All rights reserved.
//

#ifdef OGL_ES2
#	ifdef GL_FRAGMENT_PRECISION_HIGH
precision highp float;
#		define prec_high highp
#	else
precision mediump float;
#		define prec_high mediump
#	endif
#	define prec_med mediump
#	define prec_low lowp
#else 
#	define prec_high
#	define prec_med 
#	define prec_low 
#endif

#if defined(ENABLE_COLOR) && defined(ENABLE_ALPHA)
varying prec_low vec4 v_color;
#elif defined(ENABLE_COLOR)
varying prec_low vec3 v_color;
#elif defined(ENABLE_ALPHA)
varying prec_low float v_color;
#endif


#ifdef ENABLE_TEXTURE0
uniform sampler2D u_texture0;
varying prec_med vec2 v_texture0_coord;
#endif
#ifdef ENABLE_TEXTURE1
uniform sampler2D u_texture1;
varying prec_med vec2 v_texture1_coord;
#endif

#ifdef ENABLE_PROJECTEDLIGHT0
uniform sampler2D u_projected0_texture;
varying prec_med vec4 v_projected0_coord;
#endif

#ifdef ENABLE_SHADOWMAP0
varying prec_high vec4  v_shadowMap0_coord;
varying prec_high float v_shadowMap0_distance;

uniform sampler2D u_shadowMap;
uniform prec_low float u_shadowMap_acneAdjust;
#endif
#ifdef ENABLE_SHADOWMAP1
varying prec_med vec4 v_shadowMap1_coord;
varying prec_med float v_shadowMap1_distance;
#endif
#ifdef ENABLE_SHADOWMAP2
varying prec_med vec4 v_shadowMap2_coord;
varying prec_med float v_shadowMap2_distance;
#endif
#ifdef ENABLE_SHADOWMAP3
varying prec_med vec4 v_shadowMap3_coord;
varying prec_med float v_shadowMap3_distance;
#endif
#ifdef ENABLE_SHADOWMAP4
varying prec_med vec4 v_shadowMap4_coord;
varying prec_med float v_shadowMap4_distance;
#endif


#ifdef ENABLE_LIGHTMAP
varying prec_med vec2 v_lightMap_coord;
uniform prec_med sampler2D u_lightMap;
#endif

#if defined(ENABLE_PARALLAXMAP)
varying prec_high vec3 v_tangentSpace_eye;
#endif

#ifdef ENABLE_RIMLIGHT_PER_VERTEX
varying prec_low vec3 v_rimLight;
#endif

#ifdef ENABLE_RIMLIGHT_PER_PIXEL
uniform prec_low vec4 u_rimColor;
uniform prec_low float u_rimExponent;
#endif

#if defined(ENABLE_FOG_LINEAR) || defined(ENABLE_FOG_EXPONENTIAL) || defined(ENABLE_FOG_EXPONENTIAL_SQUARED)
uniform prec_low vec4 u_fogColor;

varying prec_low vec3 v_fogIntensity;
#endif

#if defined(ENABLE_ALPHATEST)
uniform prec_low float u_alphaTestValue;
#endif

#if defined(ENABLE_ENVIRONMENTCUBEMAP)
varying prec_high vec3 v_environmentCubeMapCoords;
#endif


// dependencies

#ifdef DEPENDENCY_EYE_VERTEX_DIRECTION
varying prec_high vec3 v_xyz_view_dir;
#endif

#ifdef DEPENDENCY_MATRIX_MODEL
uniform mat4 u_modelMatrix;
#endif

#ifdef DEPENDENCY_MATRIX_VIEW
uniform mat4 u_viewMatrix;
#endif

#ifdef DEPENDENCY_OBJECTSPACE_POSITION
varying prec_med vec3 v_objectSpace_position;
#endif

#ifdef DEPENDENCY_OBJECTSPACE_EYE
uniform prec_med vec3 u_objectSpace_eye;
#endif

#ifdef DEPENDENCY_WORLDSPACE_EYE
uniform prec_med vec3 u_worldSpace_eye;
#endif

#ifdef DEPENDENCY_NORMALS
varying prec_med vec3 v_normal;
#endif

#ifdef DEPENDENCY_TANGENTS
varying prec_med vec3 v_tangent;
#endif

#ifdef DEPENDENCY_NORMALMAP
uniform prec_med sampler2D u_normal_texture;
#endif

#ifdef DEPENDENCY_DELUXEMAP
uniform prec_med sampler2D u_deluxe_texture;
#endif

#ifdef DEPENDENCY_CUBEMAP
uniform prec_med samplerCube u_cubeMap;
#endif

#if !defined(ENABLE_SCREENSPACE_VERTICES)
uniform  mat4 u_modelviewProjectionMatrix;
#endif

#ifdef ENABLE_SHADOWMAP0
//void ApplyShadowMap(in float shadowMap_distance, in vec4 shadowMap_coord, inout vec4 fragmentColor)
//{
////	if (shadowMap_distance <= 0.0 )
////	{
////		fragmentColor.rgb = vec3(0.0, 0.0, 1.0);
////		return;
////	}
////    if( shadowMap_distance >= 0.999 ||   shadowMap_coord.w < 0.0 )
////    {
////        fragmentColor.rgb = vec3(1.0, 0.0, 0.0);
////        return;
////    }
////
////    prec_high vec2 shadowCoordinateWdivide = shadowMap_coord.st / shadowMap_coord.w;
////
////    if (shadowCoordinateWdivide.s < 0.0 || shadowCoordinateWdivide.s > 1.0 ||
////        shadowCoordinateWdivide.t < 0.0 || shadowCoordinateWdivide.t > 1.0)
////    {
////        fragmentColor.rgb = vec3(0.0, 1.0, 0.0);
////        return;
////    }
//
////  TODO: if we want to partition the shadowmap into smaller shadowmaps
////  it is necessary to prepare the uv coordinates
////  shadowCoordinateWdivide /= 2.0;
////  prec_med float depth = texture2D(u_shadowMap, shadowCoordinateWdivide).r;
//    
//    prec_med float depth = texture2DProj(u_shadowMap, shadowMap_coord).r;
//    
//    prec_med float shadowMap_compare = (shadowMap_coord.z / shadowMap_coord.w);
//
//    
//    // NOTE: Returns 0.0 if x < edge, otherwise it returns 1.0
//    // 'float step (float edge, float x)'
//    // It's used here to avoid branching (shadowMap_compare > depth)
//
//    fragmentColor.rgb *= 1.0 - ( shadowMap_distance  * step( depth, shadowMap_compare ) );
//}
#endif

void main()
{
	prec_low vec4 color;
	
	
#if defined(ENABLE_SHADOWMAP_PASS)
	color = vec4(1.0, 1.0, 1.0, 1.0);
#endif

#if defined(ENABLE_PARALLAXMAP)

	float height = texture2D(u_normal_texture, v_texture0_coord).r; //Our heightmap only has one color channel.
	float scale = 0.05; // FIXME: convert to uniform
	float bias = 0.02;  // FIXME: convert to uniform
	float v = height * scale - bias;
	vec2 parallaxOffset = normalize(v_tangentSpace_eye).xy * v;
	vec2 v_texture0_coord_parallaxed = v_texture0_coord - parallaxOffset;
	color = texture2D(u_texture0, v_texture0_coord_parallaxed);


#elif defined(ENABLE_TEXTURE0) && defined(ENABLE_COLOR) && defined(ENABLE_ALPHA) && defined(ENABLE_TEXTURE0_MATRIX)
    // HACK: this has to be done properly using a define: ENABLE_TEXTURE0_ALPHAONLY
	color = v_color;
    color.a *= texture2D( u_texture0, v_texture0_coord ).a;
#elif defined(ENABLE_TEXTURE0) && defined(ENABLE_COLOR) && defined(ENABLE_ALPHA)
	color = v_color * texture2D( u_texture0, v_texture0_coord );
#elif defined(ENABLE_TEXTURE0) && defined(ENABLE_COLOR)
	color = texture2D( u_texture0, v_texture0_coord );
	color.rgb *= v_color.rgb;
#elif defined(ENABLE_TEXTURE0) && defined(ENABLE_ALPHA)
	color = texture2D( u_texture0, v_texture0_coord );
	color.a *= v_color;
#elif defined(ENABLE_TEXTURE0)
	color = texture2D( u_texture0, v_texture0_coord );
#elif defined(ENABLE_COLOR) && defined(ENABLE_ALPHA)
	color = v_color;
#elif defined(ENABLE_COLOR) 
	color = vec4(v_color, 1.0);
#elif defined(ENABLE_ALPHA) 
#error alpha only is not supported
#endif

#if defined(ENABLE_ENVIRONMENTCUBEMAP)
	color = textureCube(u_cubeMap, v_environmentCubeMapCoords);
#if defined(ENABLE_COLOR)
	color *= v_color;
#elif defined(ENABLE_ALPHA)
	color.a *= v_color;
#endif
#endif


	// NOTE: we're only testing the first stage to accelerate the alpha test
#if defined(ENABLE_ALPHATEST)
	if (color.a < u_alphaTestValue)
		discard;
#endif
	
#if defined(ENABLE_TEXTURE1) && defined(ENABLE_TEXTURE1_BLEND)
	prec_low vec4 tex1Color = texture2D( u_texture1, v_texture1_coord );
	color.rgb = mix(color.rgb, tex1Color.rgb, tex1Color.a);
//    color.rgb = (color.rgb * (1.0 - tex1Color.a)) + (tex1Color.rgb * (tex1Color.a));
	color.a += tex1Color.a;
#elif defined(ENABLE_TEXTURE1) && defined(ENABLE_TEXTURE1_ADD)
	color += texture2D( u_texture1, v_texture1_coord ); /*< add texture stage #1 */
#elif defined(ENABLE_TEXTURE1)
	color *= texture2D( u_texture1, v_texture1_coord ); /*< modulate texture stage #1 */
#endif
    
    
#if defined(ENABLE_LIGHTMAP)
    vec3 lightMap = texture2D( u_lightMap, v_lightMap_coord ).rgb;

#	if defined(ENABLE_PROJECTEDLIGHT0)
    vec3 projectedMap = texture2DProj( u_projected0_texture, v_projected0_coord ).rgb;

	lightMap.rgb += projectedMap.rgb;
	// vec4 projectedMap = texture2DProj( u_projected0_texture, v_projected0_coord );
	// lightMap.rgb = mix(lightMap.rgb, projectedMap.rgb, projectedMap.a);
#	endif

	// NOTE: if bump mapping is enabled, we will mix in the lightmap with the bumpmap
    color.rgb *= lightMap.rgb;
	
#endif


#if defined(ENABLE_BUMPMAP)
	{
		// compute light direction in tangent space from deluxemap
		prec_low vec3 L = texture2D(u_deluxe_texture, v_lightMap_coord).xyz * 2.0 - 1.0;
//		L = normalize(L);

		// get bump normal 
		prec_low vec3 N = texture2D(u_normal_texture, v_texture0_coord ).xyz * 2.0 - 1.0;
		// scale normalmap to increase effect
		//	N.z *= 0.50;
		N = normalize(N);

		//	prec_low vec3 lightmap = texture2D(u_lightMap, v_lightMap_coord).rgb;
		prec_low float bump = max(dot(N, L), 0.0);

#define ENABLE_SPECMAP

#	if !defined(ENABLE_SPECMAP)
		color.rgb *= bump;
#	else
		// compute half angle
//		prec_low vec3 H = normalize(L + normalize(v_xyz_view_dir));
		prec_low vec3 H = normalize(L + normalize(u_objectSpace_eye.xyz - v_objectSpace_position.xyz));

		// compute the specular term

		// NOTE: this computes the spec based on lightmap color
//		prec_low vec3 specular = lightMap.rgb * pow(clamp(dot(N, H), 0.0, 1.0), 5.0) ;
//		color.rgb = (color.rgb * bump) + specular.rgb;

		// this computes a "plain" white specularity
		prec_low float specularTerm = pow(clamp(dot(N, H), 0.0, 1.0), 5.0);
		color.rgb = (color.rgb * bump) + specularTerm;
#	endif
	}
#endif
	
	
#if defined(ENABLE_SHADOWMAP0)
	{
		prec_med float depth = texture2DProj(u_shadowMap, v_shadowMap0_coord).r;
		prec_med float shadowMap_compare = (v_shadowMap0_coord.z / v_shadowMap0_coord.w);
		color.rgb *= 1.0 - ( v_shadowMap0_distance  * step( depth, shadowMap_compare ) );
	}
#endif
#if defined(ENABLE_SHADOWMAP1)
    ApplyShadowMap(v_shadowMap1_distance, v_shadowMap1_coord, color);
#endif
#if defined(ENABLE_SHADOWMAP2)
    ApplyShadowMap(v_shadowMap2_distance, v_shadowMap2_coord, color);
#endif
#if defined(ENABLE_SHADOWMAP3)
    ApplyShadowMap(v_shadowMap3_distance, v_shadowMap3_coord, color);
#endif
	
#if defined(ENABLE_RIMLIGHT_PER_VERTEX)
	color.rgb += v_rimLight;
#elif defined(ENABLE_RIMLIGHT_PER_PIXEL)
	prec_med vec3 normalDirection = normalize(v_normal.xyz);
	prec_med vec3 viewDirection = normalize(v_xyz_view_dir);
	prec_med float rimDot = dot(viewDirection, normalDirection) + 1.0;
//	prec_low float rimValue = smoothstep(0.5, 1.0, rimDot) * u_rimColor.a;
	prec_low float rimValue = pow(rimDot, u_rimExponent) * u_rimColor.a;
	color.rgb += u_rimColor.rgb * rimValue;
#endif


#if defined(ENABLE_FOG_LINEAR) || defined(ENABLE_FOG_EXPONENTIAL) || defined(ENABLE_FOG_EXPONENTIAL_SQUARED)
	color.rgb = mix(u_fogColor.rgb, color.rgb, v_fogIntensity);
#endif


	gl_FragColor = color;
}


